// Detect if a player cheats by spawning at a teleporters location.

class TeleSpawnCheck extends Mutator;


var PlayerPawn GibList[32];
var int GibListIndex;


function ModifyPlayer(Pawn Other)
{
	local Teleporter T;

	Super.ModifyPlayer(Other);

	if (PlayerPawn(Other) != None) {
		foreach RadiusActors(class'Teleporter', T, 100, Other.Location) {
			if (Abs(T.Location.Z - Other.Location.Z) > T.CollisionHeight + Other.CollisionHeight)
				continue; // too much vertical distance for touch

			if (VSize(vect(1,1,0) * (T.Location - Other.Location)) > T.CollisionRadius + Other.CollisionRadius)
				continue; // too much horizontal distance for touch

			// collision cylinders overlap!
			GibList[GibListIndex++] = PlayerPawn(Other);
			if (GibListIndex >= ArrayCount(GibList))
				GibListIndex = 0;
			Enable('Tick');
			break;
		}
	}
}


function Tick(float DeltaTime)
{
	local int i;

	for (i = 0; i < ArrayCount(GibList); ++i) {
		if (GibList[i] != None) {
			GibList[i].GibbedBy(Self);
			GibList[i] = None;
			log("# [DANISH] Anticheat v1.0 beta 3 - Player Using Teleporter Spawn Cheat Detected #");
		}
	}
	Disable('Tick');
}




